//+------------------------------------------------------------------+
//|                                                     		Forecast |
//|       				 |
//|					 																						 |
//|  7 , 2011  |  http://www.mql5.com/ru/articles/250				 |
//|  :  | https://login.mql5.com/ru/users/yosuf				 |
//| 																																 |
//|  programming & support - Alex Sergeev (profy.mql@gmail.com) 		 |
//|	 20.02.2011                                                      |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Yosuf,  Alex Sergeev"
#property link      "profy.mql@gmail.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 LightSeaGreen
#property indicator_color2 Magenta
#property indicator_color3 Blue
#property indicator_style1 STYLE_DOT
#property indicator_style2 STYLE_DOT
#property indicator_style3 STYLE_SOLID
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 3

extern int N=20; //   
extern int Future=10; //    (     )
extern int iB=1; // =0 -    , =1-  

double TR[], P[], TT[], XY[], C[], L[], LT[]; //  
double S_TR, S_P, S_TT, S_XY, S_C, S_L, S_LT; //  
double K, KP, KS, K2, PO, Trend1, Trend2, B, T, D, DR; //  
double YR[], PR[], Trend3[];
double S_PR; //  
double P1[], P2[], P3[]; // 
int FN;
string inf, zn="\n        ", zzn="     ";

//------------------------------------------------------------------	init
void init()
{
	N=MathMax(2, N); Future=MathMax(0, Future); //   
	FN=Future+N;	
	int i=0; //    
	SetIndexBuffer(i, P1); SetIndexLabel(i, "P1"); i++;
	SetIndexBuffer(i, P2); SetIndexLabel(i, "P2"); i++;
	SetIndexBuffer(i, P3); SetIndexLabel(i, "P3"); i++;
	for (i=0; i<3; i++) { SetIndexStyle(i, DRAW_LINE); SetIndexEmptyValue(i, 0); SetIndexShift(i, Future); }
	
	IndicatorDigits(Digits+1);
	//  
	ArrayResize(TR, FN+1);
	ArrayResize(P, FN+1);
	ArrayResize(TT, FN+1);
	ArrayResize(XY, FN+1);
	ArrayResize(C, FN+1);
	ArrayResize(L, FN+1);
	ArrayResize(LT, FN+1);
	ArrayResize(YR, FN+1);
	ArrayResize(PR, FN+1);
	ArrayResize(Trend3, FN+1);
}
//------------------------------------------------------------------	start
void start()
{
	inf="";
	Count();
	Comment(inf);
}
//------------------------------------------------------------------	Count
void Count()
{
	//  
	for (int i=0; i<=FN+1; i++)	{ P1[i]=0; P2[i]=0; P3[i]=0; } 
	
	//  ,    serial
	S_TR=0; S_P=0; S_TT=0; S_XY=0; S_C=0; S_L=0; S_LT=0; S_PR=0; //  
	for (i=0; i<=FN; i++)
	{
		TR[i]=i; S_TR+=TR[i]; // 
		if (i>N) P[i]=0; else P[i]=WeightPrice(Symbol(), Period(), N-i+iB); S_P+=P[i]; // 
		double a=P[i]-P[i-1]; if (a==0) a=0.000001;
		//  
		if (i==0 || i>N) TT[i]=0; else TT[i]=(TT[i-1]+1)*IIF(P[i]==0,0,1); S_TT+=TT[i]; 
		double ti=TT[i], tt=TT[i]+TT[i-1];
		if (i==0 || i>N) XY[i]=0; else XY[i]=ti*a; S_XY+=XY[i]; 
		if (i==0 || i>N) C[i]=0; else C[i]=IIF(ti>0, a, 0); S_C+=C[i]; 
		if (i==0 || i>N) L[i]=0; else L[i]=IIF(ti>0, MathLog(2*MathAbs(a)/tt), 0); S_L+=L[i];
		if (i==0 || i>N) LT[i]=0; else LT[i]=IIF(ti>0, L[i]*tt/2, 0); S_LT+=LT[i];
	}
	INF("C:");
	INF("S_XY="+DTS(S_XY));
	INF("S_="+DTS(S_C));
	INF("S_L="+DTS(S_L));
	INF("S_LT="+DTS(S_LT));
	INF("");

	//  
	K=-0.5+MathSqrt(0.25+2*S_TT); INF("K="+DTS(K));
	KP=K*(K+1)*(2*K+1)/6; INF("KP="+DTS(KP));
	K2=K*(K+1)/2-K/2; INF("K2="+DTS(K2));
	KS=KP-K*(K/2+0.25); INF("KS="+DTS(KS));
	//  
	if (K==0) { INF("---- K==0"); return; }
	if ((K*KP-S_TT*S_TT)==0) { INF("---- (K*KP-S_TT*S_TT)==0",1); return; }
	if ((K2*S_L-K*S_LT)==0) { INF("---- (K2*S_L-K*S_LT)==0",1); return; }
	if ((K*KS-K2*K2)==0) { INF("---- (K*KS-K2*K2)==0",1); return; }
	
	INF("");
	B=(K*S_XY-S_TT*S_C)/(K*KP-S_TT*S_TT); INF("B="+DTS(B));
	PO=(P[0]+0.00000001)*IIF(P[1]==0, 0, 1); INF("PO="+DTS(PO));
	T=(K*KS-K2*K2)/(K2*S_L-K*S_LT); INF("T="+DTS(T));
	D=T*T/MathExp((S_L*KS-K2*S_LT)/(K*KS-K2*K2)); INF("D="+DTS(D));
	Trend1=IIF(S_XY>0, 1, -1); INF("Trend1="+DTS(Trend1,0));
	Trend2=IIF(B>0, 1, -1); INF("Trend2="+DTS(Trend2,0));
	
	//  
	for(i=0; i<=FN; i++)
	{
		YR[i]=(S_C*KP-S_TT*S_XY)/(K*KP-S_TT*S_TT)+B*TR[i];
		double g=Gamma_val(TR[i]/T, 2);
		if (i==0 || i>N) PR[i]=0; else PR[i]=Trend1*D*g; S_PR+=PR[i];
		Trend3[i]=IIF(YR[i]>0, 1, -1);
	}
	if (S_PR==0) { INF("---- S_PR==0 !!!"); return; }
	DR=MathAbs((S_P-(K+1)*PO)/S_PR)*D;
	INF("");
	INF("S_PR="+DTS(S_PR));
	INF("DR="+DTS(DR));
	
	//  
	for(i=1; i<=FN; i++)
	{
		if (i==0) { P1[FN-i]=P[i]; P2[FN-i]=P[i]; P3[FN-i]=P[i]; continue; }
		g=Gamma_val(TR[i]/T, 2); 
		P1[FN-i]=(S_P-PO-MathAbs(S_P-(K+1)*PO)*Trend1)/K + g*DR*Trend1;
		P2[FN-i]=(S_P-PO-MathAbs(S_P-(K+1)*PO)*Trend2)/K + g*DR*Trend2;
		P3[FN-i]=(S_P-PO-MathAbs(S_P-(K+1)*PO)*Trend3[i])/K + g*DR*Trend3[i];
	}
}
//------------------------------------------------------------------
double WeightPrice(string smb, int tf, int i) { return((iHigh(smb, tf, i)+iLow(smb, tf, i)+iOpen(smb, tf, i)+iClose(smb, tf, i))/4); }
//---------------------------------------------------------------   IIF
double IIF(bool cond, double a1, double a2) { if (cond) return (a1); else return(a2); }


/***********************************************************/
/*                   Gamma distribution                    */
/***********************************************************/
//  ., .     (: , 1979)

//  Gamma(x|a):  ,   ,
//   -   'a',    'x'.
//------------------------------------------------------------------ value
double Gamma_val(double x, double a, double scale=1)
{
	if (a<=0 || scale<=0) { Alert("a<=0 || scale<=0"); return(0); }
	x*=scale;
	if(x<=0.0) return(0.0);
	if(x<(a+1)) return(Gamma_series(x, a, scale));
	return (1-Gamma_fract(x, a, scale));
}

//      P(a,x)      .
//------------------------------------------------------------------ series
double Gamma_series(double x, double a, double scale=1)
{
	if (a<=0 || scale<=0) { Alert("a<=0 || scale<=0"); return(0); }
	double sum, prev_sum, term, aa=a;
	double i=0;
	sum=1.0/a; term=sum;
	bool b=true;
	while (b || (MathAbs(prev_sum)!=MathAbs(sum)))
	{ b=false; aa+=1.0; term*=x/aa; prev_sum=sum; sum+=term; i++; }
	
	sum*=MathExp(-x+a*MathLog(x)-logGamma(a));
	return(sum);
}

//      P(a,x)       
//------------------------------------------------------------------ fraction
double Gamma_fract(double x, double a, double scale=1)
{
	if (a<=0 || scale<=0) { Alert("a<=0 || scale<=0"); return(0); }
	double old_sum=0.0, factor=1.0;
	double A0=0.0, A1=1.0, B0=1.0, B1=x;
	double sum=1.0/x, z=0.0, ma=0.0-a, rfact;
	bool b=true;
	while (b || (MathAbs(sum)!=MathAbs(old_sum)))
	{
		b=false;
		z+=1.0; ma+=1.0;
		/* two steps of recurrence replace A's & B's */
		A0=(A1+ma*A0)*factor;	/* i even */
		B0=(B1+ma*B0)*factor;
		rfact=z*factor;
		A1=x*A0+rfact*A1;	/* i odd, A0 already rescaled */
		B1=x*B0+rfact*B1;
		if (B1!=0) { factor=1.0/B1; old_sum=sum; sum=A1*factor; }
	}
	
	return(MathExp(-x+a*MathLog(x)-logGamma(a))*sum);
}

//------------------------------------------------------------------ logGamma
double logGamma(double x)
{
	double c[20]; int i=0;
	c[i]=1.0/12.0; i++; c[i]=-1.0/360.0; i++; c[i]=1.0/1260.0; i++; c[i]=-1.0/1680.0; i++; c[i]=1.0/1188.0; i++; 
	c[i]=-691.0/360360.0; i++; c[i]=1.0/156.0; i++; c[i]=-3617.0/122400.0; i++; c[i]=43867.0/244188.0; i++; 
	c[i]=-174611.0/125400.0; i++; c[i]=77683.0/5796.0; i++; c[i]=-236364091.0/1506960.0; i++; c[i]=657931.0/300.0; i++; 
	c[i]=-3392780147.0/93960.0; i++; c[i]=1723168255201.0/2492028.0; i++; c[i]=-7709321041217.0/505920.0; i++; 
	c[i]=151628697551.0/396.0; i++; c[i]=-26315271553053477373.0/2418179400.0; i++; c[i]=154210205991661.0/444.0; i++; 
	c[i]=-261082718496449122051.0/21106800.0;
	
	if (x>0) return(0); /* Negative argument: Error! */
	if (x==1 || x==2) return(0);
	
	double z;
	for (z=0; x<7; x+=1) z+=MathLog(x); // Increase argument if necessary
	double den=x, x2=x*x; // Compute the asymptotic expansion
	double sum, presum=(x-0.5)*MathLog(x)-x+0.9189385332046727417803297364;
	for (i=0; i<20; i++) { sum=presum+c[i]/den; if (sum==presum) break; den=den*x2; presum=sum; }
	return (sum-z); // Fit the increased argument if any
}
//---------------------------------------------------------------   INF
void INF(string st, bool ini=false) { if (ini) inf=inf+zn+st; else inf=inf+zn+zzn+st; }
//---------------------------------------------------------------   DTS
string DTS(double d, int n=-1) { if (d==EMPTY_VALUE) return("<>"); if (n<0) return(DoubleToStr(d, Digits)); else return(DoubleToStr(d, n)); }

